package app.firezone.synk.network.Activities;

import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;

import android.app.Dialog;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.widget.Toast;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Adapter.TrHistoryAdapter;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ActivityTransactionHistoryBinding;
import app.firezone.synk.network.model.TransactionModel;
import app.firezone.synk.network.model.TransactionResponse;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

import java.util.ArrayList;

public class TransactionHistoryActivity extends AppCompatActivity {

    ActivityTransactionHistoryBinding binding;
    ArrayList<TransactionModel> list;
    TrHistoryAdapter adapter;
    long userId;

    Dialog dialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityTransactionHistoryBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        binding.backArrow.setOnClickListener(v -> finish());


        dialog = new Dialog(TransactionHistoryActivity.this);
        dialog.setContentView(R.layout.loading_dialog);

        if (dialog.getWindow() !=null){

            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.setCancelable(true);
        }

        dialog.show();

        // Initialize RecyclerView
        LinearLayoutManager layoutManager = new LinearLayoutManager(this);
        binding.historyRecy.setLayoutManager(layoutManager);
        layoutManager.setReverseLayout(true);
        layoutManager.setStackFromEnd(true);
        binding.historyRecy.setHasFixedSize(true); // Optimized for fixed size data

        // Get userId from SharedPrefManager
        userId = SharedPrefManager.getInstance(this).getUserId();
        if (userId <= 0) {
            Toast.makeText(this, "Invalid user ID", Toast.LENGTH_SHORT).show();
            return;
        }

        // API call to fetch transactions
        MyApi myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);
        Call<TransactionResponse> call = myApi.fetchUserTransaction(userId);

        call.enqueue(new Callback<TransactionResponse>() {
            @Override
            public void onResponse(Call<TransactionResponse> call, Response<TransactionResponse> response) {
                dialog.dismiss();
                if (response.isSuccessful() && response.body() != null) {
                    if (response.body().isSuccess()) {
                        ArrayList<TransactionModel> list = response.body().getTransactions();
                        if (!list.isEmpty()) {
                            adapter = new TrHistoryAdapter(TransactionHistoryActivity.this, list);
                            binding.historyRecy.setAdapter(adapter);
                        } else {
                            Toast.makeText(TransactionHistoryActivity.this, "No Recent Transactions.", Toast.LENGTH_SHORT).show();
                        }
                    } else {
                        Toast.makeText(TransactionHistoryActivity.this, response.body().getMessage(), Toast.LENGTH_SHORT).show();
                    }
                } else {
                    Toast.makeText(TransactionHistoryActivity.this, "Failed to fetch transactions", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<TransactionResponse> call, Throwable t) {
                dialog.dismiss();
                Toast.makeText(TransactionHistoryActivity.this, "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });


    }
}
